# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_ROMANIAN} "(Use CD)"
LangString ReadOnly ${LANG_ROMANIAN} "(Read Only)"
LangString MainHeaderSubText ${LANG_ROMANIAN} "Introducei numele de utilizator i parola pentru noul cont"
LangString MainLanguageLabel ${LANG_ROMANIAN} "Limba"
LangString MainUsernameLabel ${LANG_ROMANIAN} "Nume de utilizator:"
LangString MainPasswordLabel ${LANG_ROMANIAN} "Parola:"
LangString MainInstallationSizeLabel ${LANG_ROMANIAN} "Mrimea instalrii (n GB):"
LangString MainDistroLabel ${LANG_ROMANIAN} "Mediu Desktop:"
LangString MainInstallationDriveLabel ${LANG_ROMANIAN} "Mrimea instalrii (n GB):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_ROMANIAN} "Installation language."
LangString MainUsernameToolTip ${LANG_ROMANIAN} "Aceasta va fi numele dumneavoastr de utilizator n Ubuntu.$\r$\nTrebuie s conin numai litere mici.$\r$\nNu trebuie s conin spaii.$\r$\nTrebuie s conin numai litere standard i cifre.$\r$\nNu poate incepe cu o cifr."
LangString MainPasswordToolTip ${LANG_ROMANIAN} "Please select a password for the new account.$\r$\nIt must not contain spaces."
LangString MainInstallationSizeToolTip ${LANG_ROMANIAN} "How many GB do you want to allocate?$\r$\n4GB is the bare minimum$\r$\n8GB is comfortable"
LangString MainInstallationDriveToolTip ${LANG_ROMANIAN} "n ce disc dorii s instalai Ubuntu?$\r$\nAcest disc ar trebui s aib 10GB liberi."
LangString Distro1ToolTip ${LANG_ROMANIAN} "Ubuntu is the default."
LangString Distro2ToolTip ${LANG_ROMANIAN} "Kubuntu uses the KDE3.5 desktop."
LangString Distro3ToolTip ${LANG_ROMANIAN} "Kubuntu-KDE4 uses the KDE4 desktop."
LangString Distro4ToolTip ${LANG_ROMANIAN} "Xubuntu is good for older systems."
LangString MainDistroToolTip ${LANG_ROMANIAN} "What graphical environment do you want to install?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_ROMANIAN} "V rog s introducei un nume de utilizator valid"
LangString ErrorSpaceInUsername ${LANG_ROMANIAN} "V rog s nu utilizai spaii n numele de utilizator."
LangString ErrorUsernameUpperCase ${LANG_ROMANIAN} "V rog sa folosii numai litere mici n numele de utilizator."
LangString ErrorUsernameFirstCharNotLetter ${LANG_ROMANIAN} "Numele de utilizator trebuie s nceap cu o liter."
LangString ErrorUsernameIllegalChars ${LANG_ROMANIAN} "Numele de utilizator trebuie s conin numai litere standard i cifre."
LangString ErrorReservedUsername ${LANG_ROMANIAN} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_ROMANIAN} "V rog s introducei o parol valid."
LangString ErrorPasswordMismatch ${LANG_ROMANIAN} "Parolele nu se potrivesc."
LangString ErrorSpaceInPassword ${LANG_ROMANIAN} "V rog s nu utilizai spaii n parola."
LangString ErrorNoFreeSpace ${LANG_ROMANIAN} "Not enough free space."
LangString ErrorNoKernel ${LANG_ROMANIAN} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_ROMANIAN} "Eroare n timpul execuiei:"
LangString ErrorWubibcd ${LANG_ROMANIAN} "Eroare n timpul execuiei:"
LangString ErrorCD2ISO ${LANG_ROMANIAN} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_ROMANIAN} "Descrcarea a fost intrerupt cu eroarea:"
LangString ErrorNoCD ${LANG_ROMANIAN} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_ROMANIAN} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_ROMANIAN} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_ROMANIAN} "Suntei pe cale s instalai"
LangString InstallHeaderInitializing ${LANG_ROMANIAN} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_ROMANIAN} "V rog s ateptai pn cand fiierele necesare sunt descrcate i pregatite"
LangString InstallHeaderUncompressWubifolder ${LANG_ROMANIAN} "Se decomprim directorul wubi..."
LangString InstallHeaderCopyIso ${LANG_ROMANIAN} "Se copiaz fiierele de instalare..."
LangString InstallHeaderDownload ${LANG_ROMANIAN} "Se descarc fiierele de instalare, continuarea este suportat"
LangString InstallHeaderBackupIso ${LANG_ROMANIAN} "Se creaz o copie de siguran a fiierelor de instalare..."
LangString InstallHeaderWritePreseed ${LANG_ROMANIAN} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_ROMANIAN} "Se pregtete programul de dezinstalare..."
LangString InstallHeaderWriteBootLoader ${LANG_ROMANIAN} "Se pregtete bootloader-ul..."
LangString InstallGenerateVirtualDisks ${LANG_ROMANIAN} "Se creaz discurile virtuale..."
LangString InstallCopyFiles ${LANG_ROMANIAN} "Se copiaz fiierele de instalare..."
LangString InstallCreateFolders ${LANG_ROMANIAN} "Creating folders..."
LangString InstallRetrieveIso ${LANG_ROMANIAN} "Se copiaz fiierele de instalare..."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_ROMANIAN} "este deja instalat"
LangString UninstallAsk ${LANG_ROMANIAN} "Do you want to uninstall it?"
LangString UninstallMessageField ${LANG_ROMANIAN} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_ROMANIAN} "Copie de siguran a fiierelor descrcate. (fiier iso CD)"
LangString UninstallBackupHomeCheckBox ${LANG_ROMANIAN} "Copie de siguran a documentelor din Ubuntu (home.disk)"
LangString UninstallBackupLocationField ${LANG_ROMANIAN} "Locaia pentru copia de siguran:"

# FINISH
LangString EjectRebootMsg ${LANG_ROMANIAN} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_ROMANIAN} "Trebuie s repornii calculatorul pentru a finaliza instalarea."

# DOWNLOADER
LangString MetadlDownloading ${LANG_ROMANIAN} "Se copiaz fiierele de instalare..."
LangString MetadlChecking ${LANG_ROMANIAN} "Se copiaz fiierele de instalare..."
LangString MetadlConnecting ${LANG_ROMANIAN} "M conectez la %s..."
LangString MetadlInitializing ${LANG_ROMANIAN} "Se iniializeaz descrcarea..."
LangString MetadlChecksums ${LANG_ROMANIAN} "Se calculzeaz sumele de calcul..."
LangString MetadlRetrying1 ${LANG_ROMANIAN} "Se rencearc n %d secunde...(%d din %d)"
LangString MetadlRetrying2 ${LANG_ROMANIAN} "Se rencearc n %d secunde..."
LangString MetadlSecond ${LANG_ROMANIAN} "secunda"
LangString MetadlSeconds ${LANG_ROMANIAN} "secunde"
LangString MetadlProgress ${LANG_ROMANIAN} "%s (%d%%) din %s la %s/s"
LangString MetadlRemaining ${LANG_ROMANIAN} " (au mai ramas %s)"
LangString PleaseConnect ${LANG_ROMANIAN} "V rog s v conectai la Internet."

# ACCESSIBILITY
LangString MobilityAids ${LANG_ROMANIAN} "Mobility Aids"
LangString VisibilityAids ${LANG_ROMANIAN} "Visibility Aids"
LangString AccessibilityButton ${LANG_ROMANIAN} "&Accessibility"
LangString AccessibilityText ${LANG_ROMANIAN} "Accessibility profile"
LangString AccessibilitySubText ${LANG_ROMANIAN} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_ROMANIAN} "None"
LangString VisibilityHighContrast ${LANG_ROMANIAN} "High Contrast"
LangString VisibilityMagnifier ${LANG_ROMANIAN} "Magnifier"
LangString VisibilityScreenReader ${LANG_ROMANIAN} "Screen Reader"
LangString VisibilityBraille ${LANG_ROMANIAN} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_ROMANIAN} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_ROMANIAN} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_ROMANIAN} "Install CD booter"
LangString CDBootText ${LANG_ROMANIAN} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_ROMANIAN} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_ROMANIAN} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_ROMANIAN} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_ROMANIAN} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_ROMANIAN} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
